<?php
/**
 * QR Code Configuration Template
 *
 * Simplified settings: background/front colors and a background transparency toggle.
 */
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 

// Get current QR code color settings
$qr_background_color = get_option('linkcentral_qr_background_color', '#FFFFFF');
$qr_front_color = get_option('linkcentral_qr_front_color', '#000000');
$qr_background_transparent = get_option('linkcentral_qr_background_transparent', false);
?>

<div class="linkcentral-qr-code-config">
	<h4><?php esc_html_e('QR Code Colors', 'linkcentral'); ?></h4>
	<p class="description"><?php esc_html_e('Customize the colors used when generating QR codes.', 'linkcentral'); ?></p>
	
	<table class="form-table">
		<tr>
			<th scope="row">
				<label for="linkcentral_qr_background_color"><?php esc_html_e('Background Color', 'linkcentral'); ?></label>
			</th>
			<td>
				<div class="linkcentral-color-picker">
					<input type="text" 
						   name="linkcentral_qr_background_color" 
						   id="linkcentral_qr_background_color" 
						   value="<?php echo esc_attr($qr_background_color); ?>" 
						   class="wp-color-picker" 
						   data-default-color="#FFFFFF">
					<label class="linkcentral-checkbox">
						<input type="checkbox" 
							   name="linkcentral_qr_background_transparent" 
							   id="linkcentral_qr_background_transparent" 
							   value="1" 
							   <?php checked($qr_background_transparent, 1); ?>>
						<?php esc_html_e('Transparent background', 'linkcentral'); ?>
					</label>
				</div>
				<p class="description"><?php esc_html_e('Set the QR code background color, or make it transparent.', 'linkcentral'); ?></p>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="linkcentral_qr_front_color"><?php esc_html_e('Front Color', 'linkcentral'); ?></label>
			</th>
			<td>
				<input type="text" 
					   name="linkcentral_qr_front_color" 
					   id="linkcentral_qr_front_color" 
					   value="<?php echo esc_attr($qr_front_color); ?>" 
					   class="wp-color-picker" 
					   data-default-color="#000000">
				<p class="description"><?php esc_html_e('Color of the QR code dots.', 'linkcentral'); ?></p>
			</td>
		</tr>
	</table>
</div>
