<?php
/**
 * Template for the Links Overview Page
 *
 * This template displays the main overview of all LinkCentral links.
 */

// Ensure this file is being included by a parent file
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 

// Display the admin header
do_action('linkcentral_admin_header');
?>

<div class="wrap linkcentral-overview">
    <h1 class="wp-heading-inline"><?php esc_html_e('All Links', 'linkcentral'); ?></h1>
    <?php 
    // Display the "Add New" button if not in trash view and user has create capability
    if ($post_status !== 'trash' && current_user_can('linkcentral_create_edit_links')): 
    ?>
        <a href="<?php echo esc_url(admin_url('post-new.php?post_type=linkcentral_link')); ?>" class="page-title-action"><?php esc_html_e('Add New', 'linkcentral'); ?></a>
    <?php endif; ?>
    <hr class="wp-header-end">

    <?php
    // Display admin notices
    settings_errors('linkcentral_notices');
    ?>

    <ul class="subsubsub">
        <?php 
        // Display the list of post status views (All, Published, Trash, etc.)
        echo wp_kses_post(implode(' | ', $list_table->get_views())); 
        ?>
    </ul>

    <!-- Search form (GET method to update URL) -->
    <form method="get">
        <?php
        // Preserve current page state for search
        foreach (['page', 'post_status', 'filter_broken', 'orderby', 'order', 'per_page'] as $param) {
            if (!empty($_GET[$param])) {
                printf('<input type="hidden" name="%s" value="%s" />', esc_attr($param), esc_attr($_GET[$param]));
            }
        }
        if (empty($_GET['page'])) echo '<input type="hidden" name="page" value="linkcentral" />';
        ?>
        <?php $list_table->search_box(__('Search links', 'linkcentral'), 'linkcentral-search'); ?>
    </form>

    <!-- Bulk actions form (POST method) -->
    <form method="post">
        <?php
        // Preserve current page state for bulk actions
        foreach (['page', 'post_status', 'filter_broken', 'orderby', 'order', 's', 'per_page'] as $param) {
            if (!empty($_GET[$param])) {
                printf('<input type="hidden" name="%s" value="%s" />', esc_attr($param), esc_attr($_GET[$param]));
            }
        }
        if (empty($_GET['page'])) echo '<input type="hidden" name="page" value="linkcentral" />';
        ?>
        <?php $list_table->display(); ?>
    </form>
</div>