<?php
/**
 * JSON Import Page Template
 *
 * This template displays the full JSON import interface with mode selection,
 * duplicate handling, and all original modal functionality.
 */
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

do_action('linkcentral_admin_header');
?>

<div class="wrap linkcentral-import">
    <div class="linkcentral-content">
        <div class="linkcentral-page-header">
            <h1><?php esc_html_e('Import from JSON', 'linkcentral'); ?></h1>
            <p class="description">
                <?php esc_html_e('Import your LinkCentral data from a JSON export file. This allows you to restore or migrate your complete LinkCentral setup.', 'linkcentral'); ?>
            </p>
        </div>

        <div class="linkcentral-card">
            <!-- Step 1: File Upload -->
            <div class="linkcentral-import-step" id="linkcentral-import-step-upload">
                <h3><?php esc_html_e('Step 1: Upload File', 'linkcentral'); ?></h3>
                <p class="description"><?php esc_html_e('Select a JSON file from LinkCentral export.', 'linkcentral'); ?></p>
                
                <div class="linkcentral-file-upload-area">
                    <input type="file" id="linkcentral-csv-file" accept=".json" style="display: none;">
                    <button type="button" class="button button-primary button-large" id="linkcentral-select-file">
                        <span class="dashicons dashicons-upload"></span>
                        <?php esc_html_e('Choose JSON File', 'linkcentral'); ?>
                    </button>
                    <p><?php esc_html_e('Select a LinkCentral JSON export file', 'linkcentral'); ?></p>

                    <div class="linkcentral-file-info" id="linkcentral-file-info" style="display: none;">
                        <p style="margin: 0;">
                            <strong><?php esc_html_e('Selected file:', 'linkcentral'); ?></strong>
                            <span id="linkcentral-file-name"></span>
                            (<span id="linkcentral-file-size"></span>)
                        </p>
                    </div>
                </div>
                
                <div class="linkcentral-import-step-actions">
                    <button type="button" class="button button-primary" id="linkcentral-analyze-file" disabled>
                        <?php esc_html_e('Analyze File', 'linkcentral'); ?>
                    </button>
                    <a href="<?php echo admin_url('admin.php?page=linkcentral-settings#linkcentral-import-export'); ?>" class="button button-secondary">
                        <?php esc_html_e('Back to Import Options', 'linkcentral'); ?>
                    </a>
                </div>
            </div>

            <!-- Step 2: Import Settings -->
            <div class="linkcentral-import-step" id="linkcentral-import-step-settings" style="display: none;">
                <h3><?php esc_html_e('Step 2: Import Settings', 'linkcentral'); ?></h3>
                <p class="description"><?php esc_html_e('Configure how the JSON data should be imported.', 'linkcentral'); ?></p>
                
                <div class="linkcentral-json-import-settings">
                    <table class="form-table">
                        <tr>
                            <th scope="row"><?php esc_html_e('Import Mode', 'linkcentral'); ?></th>
                            <td>
                                <label>
                                    <input type="radio" name="linkcentral-json-import-mode" value="migration" checked>
                                    <?php esc_html_e('Migration Mode', 'linkcentral'); ?>
                                </label>
                                <p class="description"><?php esc_html_e('Import to a new site. Links will get new IDs.', 'linkcentral'); ?></p>
                                
                                <label>
                                    <input type="radio" name="linkcentral-json-import-mode" value="restore">
                                    <?php esc_html_e('Restore Mode', 'linkcentral'); ?>
                                </label>
                                <p class="description"><?php esc_html_e('Restore to the same site. Will try to preserve original IDs.', 'linkcentral'); ?></p>
                                
                                <div id="linkcentral-restore-warning-content" style="display: none; margin-top: 10px; padding: 10px; background-color: #fff3cd; border-left: 4px solid #ffc107; color: #856404;">
                                    <strong><?php esc_html_e('Warning:', 'linkcentral'); ?></strong>
                                    <?php esc_html_e('Restore mode will overwrite existing links with the same slugs. This action cannot be undone.', 'linkcentral'); ?>
                                </div>
                                
                                <div id="linkcentral-migration-options" style="margin-top: 10px;">
                                    <label for="linkcentral-json-duplicate-handling"><?php esc_html_e('Duplicate Handling:', 'linkcentral'); ?></label>
                                    <select id="linkcentral-json-duplicate-handling">
                                        <option value="skip"><?php esc_html_e('Skip duplicates', 'linkcentral'); ?></option>
                                        <option value="overwrite"><?php esc_html_e('Overwrite existing', 'linkcentral'); ?></option>
                                    </select>
                                </div>
                            </td>
                        </tr>
                    </table>
                </div>
                
                <div class="linkcentral-import-step-actions">
                    <button type="button" class="button button-secondary" id="linkcentral-json-back-to-upload">
                        <?php esc_html_e('Back', 'linkcentral'); ?>
                    </button>
                    <button type="button" class="button button-primary" id="linkcentral-start-json-import" disabled>
                        <?php esc_html_e('Start Import', 'linkcentral'); ?>
                    </button>
                </div>
            </div>
            
            <!-- Step 3: Processing -->
            <div class="linkcentral-import-step" id="linkcentral-import-step-processing" style="display: none;">
                <h3><?php esc_html_e('Step 3: Processing', 'linkcentral'); ?></h3>
                <p class="description"><?php esc_html_e('Your import is being processed. Please wait...', 'linkcentral'); ?></p>
                
                <div class="linkcentral-progress-container">
                    <div class="linkcentral-progress-bar">
                        <div class="linkcentral-progress-fill" id="linkcentral-progress-fill" style="width: 0%;"></div>
                    </div>
                    <div class="linkcentral-progress-text">
                        <span id="linkcentral-progress-current">0</span> / <span id="linkcentral-progress-total">0</span> 
                        (<span id="linkcentral-progress-percentage">0</span>%)
                    </div>
                </div>
                
                <div class="linkcentral-processing-log">
                    <h4><?php esc_html_e('Processing Log', 'linkcentral'); ?></h4>
                    <div id="linkcentral-processing-messages"></div>
                </div>
            </div>
            
            <!-- Step 4: Results -->
            <div class="linkcentral-import-step" id="linkcentral-import-step-results" style="display: none;">
                <h3><?php esc_html_e('Step 4: Import Complete', 'linkcentral'); ?></h3>
                <p class="description"><?php esc_html_e('Your import has finished processing.', 'linkcentral'); ?></p>
                
                <div class="linkcentral-import-confirmation-summary">
                    <h4><?php esc_html_e('Import Results', 'linkcentral'); ?></h4>
                    <ul>
                        <li>• <span id="linkcentral-success-count">0</span> <?php esc_html_e('links imported successfully', 'linkcentral'); ?></li>
                        <li>• <span id="linkcentral-skipped-count">0</span> <?php esc_html_e('links skipped', 'linkcentral'); ?></li>
                        <li>
                            • <span id="linkcentral-error-count">0</span> <?php esc_html_e('links failed', 'linkcentral'); ?>
                            <div class="linkcentral-error-details" id="linkcentral-error-details" style="display: none; margin-top: 10px; margin-left: 20px;">
                                <details>
                                    <summary style="cursor: pointer; color: #666; font-size: 14px;"><?php esc_html_e('View error details', 'linkcentral'); ?></summary>
                                    <div id="linkcentral-error-list" style="margin-top: 10px; padding: 10px; background-color: #fef7f7; border-left: 3px solid #ddd; font-size: 13px; color: #666;"></div>
                                </details>
                            </div>
                        </li>
                    </ul>
                </div>
                
                <div class="linkcentral-import-step-actions">
                    <a href="<?php echo esc_url(admin_url('admin.php?page=linkcentral')); ?>" class="button button-primary">
                        <?php esc_html_e('View Imported Links', 'linkcentral'); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
