<?php
/**
 * CSV Import Page Template
 *
 * This template displays the full CSV import interface,
 * preview, and step-by-step wizard - exactly like the original modal.
 */
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

do_action('linkcentral_admin_header');
?>

<div class="wrap linkcentral-import">
    <div class="linkcentral-content">
        <div class="linkcentral-page-header">
            <h1><?php esc_html_e('Import from CSV', 'linkcentral'); ?></h1>
            <p class="description">
                <?php esc_html_e('Import your links from a CSV file. Upload a properly formatted CSV file with your link data.', 'linkcentral'); ?>
            </p>
        </div>

        <div class="linkcentral-card">
            <!-- Step 1: File Upload -->
            <div class="linkcentral-import-step" id="linkcentral-import-step-upload">
                <h3><?php esc_html_e('Step 1: Upload File', 'linkcentral'); ?></h3>
                <p class="description">
                    <?php esc_html_e('Upload a CSV file with your link data. The CSV must have these exact columns in this order:', 'linkcentral'); ?>
                </p>

                <div class="linkcentral-csv-format-requirements">
                    <h4><?php esc_html_e('Required CSV Format', 'linkcentral'); ?></h4>
                    <div class="linkcentral-csv-columns">
                        <div class="linkcentral-column-item">
                            <span class="linkcentral-column-number">1</span>
                            <strong>Title</strong>
                            <span class="linkcentral-column-required">✓ Required</span>
                        </div>
                        <div class="linkcentral-column-item">
                            <span class="linkcentral-column-number">2</span>
                            <strong>Slug</strong>
                            <span class="linkcentral-column-required">✓ Required</span>
                        </div>
                        <div class="linkcentral-column-item">
                            <span class="linkcentral-column-number">3</span>
                            <strong>Destination URL</strong>
                            <span class="linkcentral-column-required">✓ Required</span>
                        </div>
                        <div class="linkcentral-column-item">
                            <span class="linkcentral-column-number">4</span>
                            <strong>Category</strong>
                            <span class="linkcentral-column-optional">Optional</span>
                        </div>
                        <div class="linkcentral-column-item">
                            <span class="linkcentral-column-number">5</span>
                            <strong>Nofollow</strong>
                            <span class="linkcentral-column-optional">Optional</span>
                        </div>
                        <div class="linkcentral-column-item">
                            <span class="linkcentral-column-number">6</span>
                            <strong>Sponsored</strong>
                            <span class="linkcentral-column-optional">Optional</span>
                        </div>
                        <div class="linkcentral-column-item">
                            <span class="linkcentral-column-number">7</span>
                            <strong>Parameter Forwarding</strong>
                            <span class="linkcentral-column-optional">Optional</span>
                        </div>
                        <div class="linkcentral-column-item">
                            <span class="linkcentral-column-number">8</span>
                            <strong>Redirect Type</strong>
                            <span class="linkcentral-column-optional">Optional</span>
                        </div>
                        <div class="linkcentral-column-item">
                            <span class="linkcentral-column-number">9</span>
                            <strong>Note</strong>
                            <span class="linkcentral-column-optional">Optional</span>
                        </div>
                    </div>
                    <p class="description">
                        <a href="https://designforwp.com/docs/linkcentral/tools-and-other/import-data/" target="_blank" rel="noopener">
                            <?php esc_html_e('See example CSV file and detailed formatting instructions.', 'linkcentral'); ?>
                        </a>
                    </p>
                </div>
                
                <div class="linkcentral-file-upload-area">
                    <input type="file" id="linkcentral-csv-file" accept=".csv" style="display: none;">
                    <button type="button" class="button button-primary button-large" id="linkcentral-select-file">
                        <span class="dashicons dashicons-upload"></span>
                        <?php esc_html_e('Choose CSV File', 'linkcentral'); ?>
                    </button>
                    <p><?php esc_html_e('Select a CSV file to import your links', 'linkcentral'); ?></p>

                    <div class="linkcentral-file-info" id="linkcentral-file-info" style="display: none;">
                        <p style="margin: 0;">
                            <strong><?php esc_html_e('Selected file:', 'linkcentral'); ?></strong>
                            <span id="linkcentral-file-name"></span>
                            (<span id="linkcentral-file-size"></span>)
                        </p>
                    </div>
                </div>
                
                <div class="linkcentral-import-step-actions">
                    <button type="button" class="button button-primary" id="linkcentral-analyze-file" disabled>
                        <?php esc_html_e('Continue to Settings', 'linkcentral'); ?>
                    </button>
                    <a href="<?php echo admin_url('admin.php?page=linkcentral-settings#linkcentral-import-export'); ?>" class="button button-secondary">
                        <?php esc_html_e('Back to Import Options', 'linkcentral'); ?>
                    </a>
                </div>
            </div>

            <!-- Step 2: Import Settings -->
            <div class="linkcentral-import-step" id="linkcentral-import-step-settings" style="display: none;">
                <h3><?php esc_html_e('Step 2: Import Settings', 'linkcentral'); ?></h3>
                <p class="description"><?php esc_html_e('Configure how the import should be processed.', 'linkcentral'); ?></p>
                
                <div class="linkcentral-import-confirmation-summary">
                    <h4><?php esc_html_e('Import Summary', 'linkcentral'); ?></h4>
                    <p><?php esc_html_e('Ready to import', 'linkcentral'); ?> <strong><span id="linkcentral-total-rows">0</span></strong> <?php esc_html_e('rows from your CSV file.', 'linkcentral'); ?></p>
                </div>
                
                <table class="form-table">
                    <tr>
                        <th scope="row">
                            <label for="linkcentral-duplicate-handling"><?php esc_html_e('Duplicate Handling', 'linkcentral'); ?></label>
                        </th>
                        <td>
                            <select id="linkcentral-duplicate-handling">
                                <option value="skip"><?php esc_html_e('Skip duplicates (recommended)', 'linkcentral'); ?></option>
                                <option value="update"><?php esc_html_e('Update existing links', 'linkcentral'); ?></option>
                            </select>
                            <p class="description">
                                <?php esc_html_e('How to handle links that already exist in LinkCentral (based on slug).', 'linkcentral'); ?>
                            </p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="linkcentral-create-categories"><?php esc_html_e('Create Categories', 'linkcentral'); ?></label>
                        </th>
                        <td>
                            <label class="linkcentral-toggle-switch">
                                <input type="checkbox" id="linkcentral-create-categories" checked>
                                <span class="linkcentral-toggle-slider"></span>
                            </label>
                            <span class="linkcentral-toggle-label">
                                <?php esc_html_e('Automatically create categories that don\'t exist', 'linkcentral'); ?>
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="linkcentral-force-prefix"><?php esc_html_e('Force Prefix', 'linkcentral'); ?></label>
                        </th>
                        <td>
                            <label class="linkcentral-toggle-switch">
                                <input type="checkbox" id="linkcentral-force-prefix">
                                <span class="linkcentral-toggle-slider"></span>
                            </label>
                            <span class="linkcentral-toggle-label">
                                <?php esc_html_e('Add URL prefix to all imported links', 'linkcentral'); ?>
                            </span>
                            <p class="description">
                                <?php
                                /* translators: %s: URL prefix (e.g., 'go') */
                                printf(esc_html__('When enabled, all links will use the URL prefix "%s" even if they start with it.', 'linkcentral'), get_option('linkcentral_url_prefix', 'go'));
                                ?>
                            </p>
                        </td>
                    </tr>
                </table>
                
                <div class="linkcentral-import-step-actions">
                    <button type="button" class="button button-secondary" id="linkcentral-back-to-upload">
                        <?php esc_html_e('Back', 'linkcentral'); ?>
                    </button>
                    <button type="button" class="button button-primary" id="linkcentral-start-import-process">
                        <?php esc_html_e('Start Import', 'linkcentral'); ?>
                    </button>
                </div>
            </div>
            
            <!-- Step 3: Processing -->
            <div class="linkcentral-import-step" id="linkcentral-import-step-processing" style="display: none;">
                <h3><?php esc_html_e('Step 3: Processing', 'linkcentral'); ?></h3>
                <p class="description"><?php esc_html_e('Your import is being processed. Please wait...', 'linkcentral'); ?></p>
                
                <div class="linkcentral-progress-container">
                    <div class="linkcentral-progress-bar">
                        <div class="linkcentral-progress-fill" id="linkcentral-progress-fill" style="width: 0%;"></div>
                    </div>
                    <div class="linkcentral-progress-text">
                        <span id="linkcentral-progress-current">0</span> / <span id="linkcentral-progress-total">0</span> 
                        (<span id="linkcentral-progress-percentage">0</span>%)
                    </div>
                </div>
                
                <div class="linkcentral-processing-log">
                    <h4><?php esc_html_e('Processing Log', 'linkcentral'); ?></h4>
                    <div id="linkcentral-processing-messages"></div>
                </div>
            </div>
            
            <!-- Step 4: Results -->
            <div class="linkcentral-import-step" id="linkcentral-import-step-results" style="display: none;">
                <h3><?php esc_html_e('Step 4: Import Complete', 'linkcentral'); ?></h3>
                <p class="description"><?php esc_html_e('Your import has finished processing.', 'linkcentral'); ?></p>
                
                <div class="linkcentral-import-confirmation-summary">
                    <h4><?php esc_html_e('Import Results', 'linkcentral'); ?></h4>
                    <ul>
                        <li>• <span id="linkcentral-success-count">0</span> <?php esc_html_e('links imported successfully', 'linkcentral'); ?></li>
                        <li>• <span id="linkcentral-skipped-count">0</span> <?php esc_html_e('links skipped', 'linkcentral'); ?></li>
                        <li>
                            • <span id="linkcentral-error-count">0</span> <?php esc_html_e('links failed', 'linkcentral'); ?>
                            <div class="linkcentral-error-details" id="linkcentral-error-details" style="display: none; margin-top: 10px; margin-left: 20px;">
                                <details>
                                    <summary style="cursor: pointer; color: #666; font-size: 14px;"><?php esc_html_e('View error details', 'linkcentral'); ?></summary>
                                    <div id="linkcentral-error-list" style="margin-top: 10px; padding: 10px; background-color: #fef7f7; border-left: 3px solid #ddd; font-size: 13px; color: #666;"></div>
                                </details>
                            </div>
                        </li>
                    </ul>
                </div>
                
                <div class="linkcentral-import-step-actions">
                    <a href="<?php echo esc_url(admin_url('admin.php?page=linkcentral')); ?>" class="button button-primary">
                        <?php esc_html_e('View Imported Links', 'linkcentral'); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
