import TotalClicks from '../insights/total-clicks';
import MostPopularLinks from '../insights/most-popular-links';
import RecentClicks from '../insights/recent-clicks';

import SharedDateRangeSelector from '../insights/ui/date-range-selector';
import SharedLinkSelector from '../insights/ui/link-selector';

document.addEventListener('DOMContentLoaded', function() {
    // Create shared selectors first
    const dateRangeSelector = new SharedDateRangeSelector();
    const linkSelector = new SharedLinkSelector();
    
    dateRangeSelector.init();
    linkSelector.init();
    
    // Create components with shared selectors
    const totalClicks = new TotalClicks(dateRangeSelector, linkSelector);
    const mostPopularLinks = new MostPopularLinks(dateRangeSelector, linkSelector);
    const recentClicks = new RecentClicks();

    totalClicks.init();
    mostPopularLinks.init();
    recentClicks.init();

    
    
    // Trigger initial data load after all components are initialized
    dateRangeSelector.triggerInitialLoad();
});