(function($) {
    'use strict';

    // Handle migration notice dismissal (global functionality)
    $(document).on('click', '.linkcentral-dismiss-notice', function(e) {
        e.preventDefault();

        var $this = $(this);
        var noticeType = $this.data('notice');
        var $notice = $this.closest('.notice');

        $.post(linkcentral_admin.ajax_url, {
            action: 'linkcentral_dismiss_' + noticeType + '_notice',
            nonce: linkcentral_admin.dismiss_nonce
        }, function(response) {
            if (response.success) {
                $notice.fadeOut(300, function() {
                    $notice.remove();
                });
            } else {
                console.error('Failed to dismiss notice:', response.data);
            }
        }).fail(function(xhr, status, error) {
            console.error('AJAX error dismissing notice:', status, error);
        });
    });

})(jQuery);
