<?php
/**
 * LinkCentral Insights Helper Functions
 *
 * This file contains shared utility functions used across multiple insights components.
 */
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 

class LinkCentral_Insights_Helpers {
    
    /**
     * Get link IDs that belong to a specific category.
     *
     * @param int $category_id The category ID
     * @return array Array of link IDs
     */
    public static function get_link_ids_by_category($category_id) {
        $args = array(
            'post_type' => 'linkcentral_link',
            'post_status' => array('publish', 'draft', 'private'),
            'posts_per_page' => -1,
            'fields' => 'ids',
            'tax_query' => array(
                array(
                    'taxonomy' => 'linkcentral_category',
                    'field' => 'term_id',
                    'terms' => $category_id,
                ),
            ),
        );

        $query = new WP_Query($args);
        return $query->posts;
    }
} 